/*
 * Decompiled with CFR 0.152.
 */
package com.roguewave.chart.overlay.overlays.v2_1;

import com.roguewave.chart.core.v2_1.ChartGraphics;
import com.roguewave.chart.core.v2_1.DataModel;
import com.roguewave.chart.drawables.device.v2_1.DeviceLines;
import com.roguewave.chart.overlay.core.v2_1.Log10Scale;
import com.roguewave.chart.overlay.core.v2_1.Log10Scaler;
import com.roguewave.chart.overlay.core.v2_1.NumericFormatter;
import com.roguewave.chart.overlay.core.v2_1.ParameterCalculator;
import com.roguewave.chart.overlay.core.v2_1.ScaleConstants;
import com.roguewave.chart.overlay.overlays.v2_1.ScaleOverlayBase;
import java.awt.Color;
import java.awt.Font;

public class Log10ScaleOverlay
extends ScaleOverlayBase
implements Log10Scale,
ScaleConstants {
    int ticksPerIncrement_ = 10;
    int tickSize_ = 3;
    Color tickColor_ = Color.gray;

    public Log10ScaleOverlay(boolean scale, NumericFormatter formatter, Color color, Font font) {
        super(scale, formatter, color, font);
        super.setScaleOffset(this.tickSize_ + 2);
    }

    public Log10ScaleOverlay(boolean scale, NumericFormatter formatter, Color color, Font font, int ticksPerIncrement, int tickSize) {
        super(scale, formatter, color, font);
        this.ticksPerIncrement_ = ticksPerIncrement;
        this.tickSize_ = tickSize;
        super.setScaleOffset(this.tickSize_ + 2);
    }

    protected double calcValue(ParameterCalculator params, int i) {
        return Math.pow(10.0, params.getLowIncrement() + i);
    }

    public void addTo(ChartGraphics chartGraphics, DataModel data, int base, int left, int right, int offset, int columnWidth, ParameterCalculator params1, ParameterCalculator params2) {
        if (this.tickSize_ > 0) {
            ParameterCalculator params;
            int tickSign;
            int x;
            if (this.scale_) {
                x = left - 1;
                tickSign = -1;
                params = params1;
            } else {
                x = right + 1;
                tickSign = 1;
                params = params2;
            }
            int pixelsPerIncrement = params.getPixelsPerIncrement();
            int count = params.getHighIncrement() - params.getLowIncrement() + 1 - this.highLabelOffset_ - this.lowLabelOffset_;
            double tickInc = 10.0 / (double)this.ticksPerIncrement_;
            int[] logOffsets = new int[this.ticksPerIncrement_];
            logOffsets[0] = 0;
            int ticks = (count - 1) * this.ticksPerIncrement_ + 1;
            for (int i = 1; i < this.ticksPerIncrement_; ++i) {
                logOffsets[i] = (int)(Log10Scaler.log10(tickInc * (double)i) * (double)pixelsPerIncrement + 0.5);
            }
            int[] y = new int[ticks];
            int[] x1 = new int[ticks];
            int[] x2 = new int[ticks];
            int index = 0;
            for (int i = 0; i < count; ++i) {
                int yb;
                y[index] = yb = base - (i + this.lowLabelOffset_) * pixelsPerIncrement;
                x1[index] = x;
                x2[index++] = x + tickSign * this.tickSize_;
                if (i >= count - 1) continue;
                for (int j = 1; j < this.ticksPerIncrement_; ++j) {
                    y[index] = yb - logOffsets[j];
                    x1[index] = x;
                    x2[index++] = x + tickSign * (this.tickSize_ * 2 / 3);
                }
            }
            chartGraphics.add2DDrawable(new DeviceLines(x1, y, x2, y, this.tickColor_));
        }
        super.addTo(chartGraphics, data, base, left, right, offset, columnWidth, params1, params2);
    }

    public int getTicksPerIncrement() {
        return this.ticksPerIncrement_;
    }

    public void setTicksPerIncrement(int ticks) {
        if (ticks > 10) {
            return;
        }
        this.ticksPerIncrement_ = ticks;
    }

    public int getTickSize() {
        return this.tickSize_;
    }

    public void setTickSize(int size) {
        this.tickSize_ = size;
        this.setScaleOffset(this.tickSize_ + 2);
    }

    public Color getTickColor() {
        return this.tickColor_;
    }

    public void setTickColor(Color tickColor) {
        this.tickColor_ = tickColor;
    }
}

